﻿//////////////////////////////////////////////
// TextureManager.h
//
//////////////////////////////////////////////

/// Defines / Macros -------------------------

#pragma once

/// Includes ---------------------------------

// nkGraphics
#include "../Dll/DllDefines.h"

#include "../Utils/Manager.h"

#include "Texture.h"

// nkCommon
#include <nilkinsCommon/Patterns/MaybeSingletonClass.h>

// nkMemory
#include <NilkinsMemory/Pointers/UniquePtr.h>

// Standards
#include <string>
#include <string_view>
#include <unordered_map>

/// Class ------------------------------------

namespace nkGraphics
{
	class DLL_GRAPHICS_EXPORT TextureManager final : public Manager<Texture>, public nkCommon::MaybeSingletonClass<TextureManager>
	{
		public :

			// Available default resource names
			inline static const nkMemory::StringView DEFAULT_TEXTURE = "NILKINS_DEFAULT_TEXTURE" ;

		public :

			// Getters
			Texture* getActiveRenderTarget () const ;
			Texture* getDepthTarget () const ;

			// Setters
			void setActiveRenderTarget (Texture* target) ;
			void setActiveDepthTarget (Texture* target) ;

		private :

			// Constructors
			TextureManager (bool isSingleton) noexcept ;
			TextureManager (System* system) noexcept ;

		private :
		
			// Attributes
			Texture* _activeRenderTarget ;
			Texture* _activeDepthTarget ;

		private :

			friend class nkCommon::MaybeSingletonClass<TextureManager> ;
			friend class System ;
	} ;
}